<?php
session_start();
include 'koneksi.php';

// Pastikan user login
if (!isset($_SESSION['id_user'])) {
    die("Unauthorized");
}

// Set zona waktu ke Indonesia
date_default_timezone_set('Asia/Jakarta');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $merek      = trim($_POST['merek']);
    $tipe       = $_POST['tipe'];
    $id_area    = $_POST['id_area'];
    $id_user    = $_SESSION['id_user'];
    $date_created = date('Y-m-d H:i:s');
    $id_reguler = $_POST['id_reguler']; // ambil dari form


    // Set jumlah default = 0
    $jumlah = 0;

    // $stmt = $conn->prepare("INSERT INTO tbl_kendaraan (merek, tipe, jumlah, id_area, id_user, date_created) VALUES (?, ?, ?, ?, ?, ?)");
    // $stmt->bind_param("ssiiis", $merek, $tipe, $jumlah, $id_area, $id_user, $date_created);
    $stmt = $conn->prepare("INSERT INTO tbl_kendaraan (merek, tipe, jumlah, id_area, id_reguler, id_user, date_created) VALUES (?, ?, 0, ?, ?, ?, ?)");
    $stmt->bind_param("ssiiss", $merek, $tipe, $id_area, $id_reguler, $id_user, $date_created);
    if ($stmt->execute()) {
        header("Location: index.php");
    } else {
        echo "Gagal menambahkan data kendaraan.";
    }
}
