<?php
require_once 'vendor/autoload.php';

use Dompdf\Dompdf;

include 'koneksi.php';
session_start();

// Pastikan user login
$username_login = $_SESSION['username'] ?? 'Tidak Diketahui';

$selected_tipe = $_GET['tipe'] ?? 'motor';
$selected_area = isset($_GET['area']) ? intval($_GET['area']) : 0;
$start_date = $_GET['start_date'] ?? null;
$end_date = $_GET['end_date'] ?? null;

$where = [];

if ($selected_tipe != 'semua') {
    $where[] = "k.tipe = '" . $conn->real_escape_string($selected_tipe) . "'";
}
if ($selected_area > 0) {
    $where[] = "k.id_area = $selected_area";
}
if ($start_date && $end_date) {
    $where[] = "DATE(k.date_created) BETWEEN '$start_date' AND '$end_date'";
}

$area_nama = 'Semua Area';
if ($selected_area > 0) {
    $area_result = $conn->query("SELECT nama_area FROM tbl_area WHERE id_area = $selected_area");
    if ($area_row = $area_result->fetch_assoc()) {
        $area_nama = $area_row['nama_area'];
    }
}

$sql = "SELECT k.id, k.merek, k.tipe, a.nama_area, k.jumlah, u.username, k.date_created
        FROM tbl_kendaraan k
        JOIN tbl_area a ON k.id_area = a.id_area
        LEFT JOIN tbl_user u ON k.id_user = u.id_user";

if (!empty($where)) {
    $sql .= " WHERE " . implode(" AND ", $where);
}
$sql .= " ORDER BY a.nama_area, k.merek";

$res = $conn->query($sql);

$total_motor = 0;
$total_mobil = 0;
$total_semua = 0;
$tanggal_cetak = date('d-m-Y H:i');

// BASE64 logo
$logo_path = 'Unpam.png';
$logo_base64 = '';
if (file_exists($logo_path)) {
    $logo_type = pathinfo($logo_path, PATHINFO_EXTENSION);
    $logo_data = file_get_contents($logo_path);
    $logo_base64 = 'data:image/' . $logo_type . ';base64,' . base64_encode($logo_data);
}

// HTML
$html = '
<style>
    body {
        font-family: Arial, sans-serif;
        font-size: 12px;
        color: #333;
    }
    .header {
        display: flex;
        align-items: center;
        margin-bottom: 10px;
        border-bottom: 2px solid #3498db;
        padding-bottom: 10px;
    }
    .logo {
        width: 60px;
        height: 60px;
        margin-right: 15px;
    }
    .info {
        font-size: 12px;
    }
    h3 {
        text-align: center;
        color: #2c3e50;
        margin-top: 10px;
        margin-bottom: 5px;
    }
    .meta {
        margin-bottom: 15px;
        font-size: 11px;
    }
    table {
        border-collapse: collapse;
        width: 100%;
    }
    th {
        background-color: #3498db;
        color: white;
        padding: 8px;
        text-align: center;
    }
    td {
        padding: 7px;
        border: 1px solid #ddd;
    }
    tr:nth-child(even) {
        background-color: #f9f9f9;
    }
    tfoot td {
        background-color: #ecf0f1;
        font-weight: bold;
    }
</style>

<div class="header">
    <img src="' . $logo_base64 . '" class="logo">
    <div class="info">
        <strong>Laporan Kendaraan Terparkir</strong><br>
        Dicetak oleh: ' . htmlspecialchars($username_login) . '<br>
        Tanggal Cetak: ' . $tanggal_cetak . '<br>';

if ($start_date && $end_date) {
    $html .= 'Periode: ' . date('d-m-Y', strtotime($start_date)) . ' s.d. ' . date('d-m-Y', strtotime($end_date)) . '<br>';
}

$html .= '
    </div>
</div>

<h3>Area: ' . htmlspecialchars($area_nama) . '</h3>

<table>
<thead>
    <tr>
        <th>No</th>
        <th>Merek</th>
        <th>Tipe</th>
        <th>Area</th>
        <th>Jumlah</th>
        <th>User</th>
        <th>Tanggal Input</th>
    </tr>
</thead>
<tbody>';

$no = 1;
while ($row = $res->fetch_assoc()) {
    $jumlah = (int)$row['jumlah'];
    $tipe = $row['tipe'];

    if ($tipe === 'motor') $total_motor += $jumlah;
    elseif ($tipe === 'mobil') $total_mobil += $jumlah;

    $total_semua += $jumlah;

    $html .= '<tr>
        <td align="center">' . $no++ . '</td>
        <td>' . htmlspecialchars($row['merek']) . '</td>
        <td>' . ucfirst($tipe) . '</td>
        <td>' . htmlspecialchars($row['nama_area']) . '</td>
        <td align="center">' . $jumlah . '</td>
        <td>' . htmlspecialchars($row['username'] ?? '-') . '</td>
        <td>' . (!empty($row['date_created']) ? date('d-m-Y', strtotime($row['date_created'])) : '-') . '</td>
    </tr>';
}

$html .= '</tbody><tfoot>';

if ($selected_tipe === 'semua') {
    $html .= '
    <tr>
        <td colspan="4" align="right">Jumlah Motor:</td>
        <td align="center">' . $total_motor . '</td>
        <td colspan="2"></td>
    </tr>
    <tr>
        <td colspan="4" align="right">Jumlah Mobil:</td>
        <td align="center">' . $total_mobil . '</td>
        <td colspan="2"></td>
    </tr>
    <tr>
        <td colspan="4" align="right">Total Semua Kendaraan:</td>
        <td align="center">' . $total_semua . '</td>
        <td colspan="2"></td>
    </tr>';
} else {
    $html .= '
    <tr>
        <td colspan="4" align="right">Total Kendaraan:</td>
        <td align="center">' . $total_semua . '</td>
        <td colspan="2"></td>
    </tr>';
}

$html .= '</tfoot></table>';

// Generate PDF
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("laporan_kendaraan.pdf", array("Attachment" => false));
exit;
