<?php
session_start();
include 'koneksi.php';

// Cek login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// Filter
$where = [];
if (!empty($_GET['id_area'])) {
    $where[] = "k.id_area = " . intval($_GET['id_area']);
}
if (!empty($_GET['id_reguler'])) {
    $where[] = "k.id_reguler = " . intval($_GET['id_reguler']);
}
$filterSql = !empty($where) ? "WHERE " . implode(" AND ", $where) : "";

// Query data
$query = "
  SELECT k.id, k.merek, k.tipe, k.jumlah, a.nama_area, r.nama_reguler 
  FROM tbl_kendaraan k
  JOIN tbl_area a ON k.id_area = a.id_area
  LEFT JOIN tbl_reguler r ON k.id_reguler = r.id_reguler
  $filterSql
  ORDER BY a.nama_area, k.tipe
";
$result = $conn->query($query);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Hitung Kendaraan Terparkir</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .counter-btn {
            width: 40px;
        }
    </style>
</head>

<body class="bg-light">

    <div class="container mt-5">
        <h3 class="text-center mb-4">Data Kendaraan Terparkir</h3>

        <div class="d-flex justify-content-end mb-3">
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalTambah">Tambah Kendaraan</button>
        </div>

        <form method="GET" class="row mb-4">
            <div class="col-md-4">
                <select name="id_area" class="form-select">
                    <option value="">-- Semua Area --</option>
                    <?php
                    $area = $conn->query("SELECT * FROM tbl_area");
                    while ($a = $area->fetch_assoc()): ?>
                        <option value="<?= $a['id_area']; ?>" <?= @$_GET['id_area'] == $a['id_area'] ? 'selected' : '' ?>>
                            <?= $a['nama_area']; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            <div class="col-md-4">
                <select name="id_reguler" class="form-select">
                    <option value="">-- Semua Reguler --</option>
                    <?php
                    $reg = $conn->query("SELECT * FROM tbl_reguler");
                    while ($r = $reg->fetch_assoc()): ?>
                        <option value="<?= $r['id_reguler']; ?>" <?= @$_GET['id_reguler'] == $r['id_reguler'] ? 'selected' : '' ?>>
                            <?= $r['nama_reguler']; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            <div class="col-md-4">
                <button class="btn btn-secondary w-100">Filter</button>
            </div>
        </form>

        <table class="table table-bordered table-striped">
            <thead class="table-dark text-center">
                <tr>
                    <th>No</th>
                    <th>Merek</th>
                    <th>Tipe</th>
                    <th>Lokasi</th>
                    <th>Reguler</th>
                    <th>Jumlah</th>
                    <th>Kontrol</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1;
                while ($row = $result->fetch_assoc()): ?>
                    <tr class="text-center">
                        <td><?= $no++; ?></td>
                        <td><?= $row['merek']; ?></td>
                        <td><?= ucfirst($row['tipe']); ?></td>
                        <td><?= $row['nama_area']; ?></td>
                        <td><?= $row['nama_reguler'] ?? '-'; ?></td>
                        <td id="count-<?= $row['id']; ?>"><?= $row['jumlah']; ?></td>
                        <td>
                            <button class="btn btn-success btn-sm counter-btn" onclick="updateCount(<?= $row['id']; ?>, 'plus')">+</button>
                            <button class="btn btn-danger btn-sm counter-btn" onclick="updateCount(<?= $row['id']; ?>, 'minus')">-</button>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <!-- Modal Tambah -->
    <div class="modal fade" id="modalTambah" tabindex="-1" aria-labelledby="modalTambahLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form action="tambah.php" method="POST">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalTambahLabel">Tambah Kendaraan</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Merek</label>
                            <input type="text" class="form-control" name="merek" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Tipe</label>
                            <select name="tipe" class="form-select" required>
                                <option value="">-- Pilih --</option>
                                <option value="motor">Motor</option>
                                <option value="mobil">Mobil</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Area</label>
                            <select name="id_area" class="form-select" required>
                                <option value="">-- Pilih Area --</option>
                                <?php
                                $area = $conn->query("SELECT * FROM tbl_area ORDER BY nama_area");
                                while ($a = $area->fetch_assoc()): ?>
                                    <option value="<?= $a['id_area']; ?>"><?= $a['nama_area']; ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Reguler</label>
                            <select name="id_reguler" class="form-select" required>
                                <option value="">-- Pilih Reguler --</option>
                                <?php
                                $reguler = $conn->query("SELECT * FROM tbl_reguler ORDER BY nama_reguler");
                                while ($r = $reguler->fetch_assoc()): ?>
                                    <option value="<?= $r['id_reguler']; ?>"><?= $r['nama_reguler']; ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Simpan</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function updateCount(id, action) {
            $.post('update.php', {
                id: id,
                action: action
            }, function(response) {
                if (response.success) {
                    $('#count-' + id).text(response.new_count);
                } else {
                    alert(response.message);
                }
            }, 'json');
        }
    </script>

</body>

</html>