<?php
include 'koneksi.php';

// $conn = new mysqli("localhost", "root", "", "db_kendaraan");

// Query gabungan dengan hitung jumlah berdasarkan kombinasi area, type, merek
$sql = "
    SELECT 
        h.id_area,
        h.id_type,
        h.id_merek,
        a.nama_area,
        t.nama_type,
        m.nama_merek,
        COUNT(h.id_hitung) AS jumlah
    FROM tbl_hitung h
    JOIN tbl_area a ON h.id_area = a.id_area
    JOIN tbl_type t ON h.id_type = t.id_type
    JOIN tbl_merek m ON h.id_merek = m.id_merek
    GROUP BY h.id_area, h.id_type, h.id_merek
    ORDER BY a.nama_area, t.nama_type, m.nama_merek
";

$result = $conn->query($sql);

echo "<table>";
echo "<tr><th>Area</th><th>Type</th><th>Merek</th><th>Jumlah</th><th>Action</th></tr>";

while ($row = $result->fetch_assoc()) {
    echo "<tr>
            <td>{$row['nama_area']}</td>
            <td>{$row['nama_type']}</td>
            <td>{$row['nama_merek']}</td>
            <td>{$row['jumlah']}</td>
            <td>
                <button class='btn-minus' data-area='{$row['id_area']}' data-type='{$row['id_type']}' data-merek='{$row['id_merek']}'>-</button>
                <button class='btn-plus' data-area='{$row['id_area']}' data-type='{$row['id_type']}' data-merek='{$row['id_merek']}'>+</button>
            </td>
        </tr>";
}

echo "</table>";
$conn->close();
