<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-col sm:flex-row justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
                <i class="fas fa-clipboard-list mr-2"></i>
                {{ __('Detail Jenis Tugas') }}
            </h2>
            <div class="mt-4 sm:mt-0 flex space-x-2">
                <a href="{{ route('master.task_types.index') }}"
                    class="inline-flex items-center px-4 py-2 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-500 rounded-md font-semibold text-xs text-gray-700 dark:text-gray-300 uppercase tracking-widest shadow-sm hover:bg-gray-50 dark:hover:bg-gray-700">
                    <i class="fas fa-arrow-left me-2"></i>
                    Kembali
                </a>
                <a href="{{ route('master.task_types.edit', $data['taskType']->id) }}"
                    class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-700">
                    <i class="fas fa-edit me-2"></i>
                    Edit
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-lg sm:rounded-lg">
                <div class="p-6 md:p-8 text-gray-900 dark:text-gray-100">

                    {{-- Header Detail --}}
                    <div
                        class="flex justify-between items-start mb-6 pb-6 border-b border-gray-200 dark:border-gray-700">
                        <div>
                            <h3 class="text-2xl font-bold text-gray-900 dark:text-gray-100">{{
                                $data['taskType']->name_task }}</h3>
                            <p class="mt-1 text-md text-gray-500 dark:text-gray-400">
                                Departemen: <span class="font-semibold">{{ $data['taskType']->departemen }}</span>
                            </p>
                        </div>
                        <div>
                            @php
                            $priority = $data['taskType']->priority_level;
                            $priorityClass = [
                            'low' => 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300',
                            'medium' => 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300',
                            'high' => 'bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-300',
                            'critical' => 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300'
                            ][$priority] ?? 'bg-gray-100';
                            @endphp
                            <span
                                class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full capitalize {{ $priorityClass }}">
                                Prioritas {{ $priority }}
                            </span>
                        </div>
                    </div>

                    {{-- Konten Detail --}}
                    <div>
                        <dl class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-6">

                            {{-- Deskripsi Lengkap --}}
                            <div class="md:col-span-2">
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 flex items-center">
                                    <i class="fas fa-align-left fa-fw mr-3"></i>Deskripsi
                                </dt>
                                <dd class="mt-1 text-base text-gray-900 dark:text-gray-100">{{
                                    $data['taskType']->description ?? 'Tidak ada deskripsi.' }}</dd>
                            </div>

                            {{-- Dibuat Pada --}}
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 flex items-center">
                                    <i class="fas fa-calendar-plus fa-fw mr-3"></i>Dibuat Pada
                                </dt>
                                <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                                    @tanggal($data['taskType']->created_at)</dd>
                            </div>

                            {{-- Diperbarui Pada --}}
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 flex items-center">
                                    <i class="fas fa-calendar-check fa-fw mr-3"></i>Diperbarui Pada
                                </dt>
                                <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                                    @tanggal($data['taskType']->updated_at)</dd>
                            </div>
                        </dl>
                    </div>

                </div>
            </div>
        </div>
    </div>
</x-app-layout>