-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               8.0.30 - MySQL Community Server - GPL
-- Server OS:                    Win64
-- HeidiSQL Version:             12.1.0.6537
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- Dumping structure for table db_mapro.assets
CREATE TABLE IF NOT EXISTS `assets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_by` bigint unsigned DEFAULT NULL,
  `room_id` bigint unsigned DEFAULT NULL,
  `location_detail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name_asset` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `asset_category_id` bigint unsigned DEFAULT NULL,
  `asset_type` enum('fixed_asset','consumable') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed_asset',
  `serial_number` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `purchase_date` date DEFAULT NULL,
  `condition` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('available','in_use','maintenance','disposed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `current_stock` int unsigned NOT NULL DEFAULT '0',
  `minimum_stock` int unsigned NOT NULL DEFAULT '0',
  `updated_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `assets_serial_number_unique` (`serial_number`),
  KEY `assets_room_id_foreign` (`room_id`),
  KEY `assets_updated_by_foreign` (`updated_by`),
  KEY `assets_created_by_foreign` (`created_by`),
  KEY `assets_asset_category_id_foreign` (`asset_category_id`),
  CONSTRAINT `assets_asset_category_id_foreign` FOREIGN KEY (`asset_category_id`) REFERENCES `asset_categories` (`id`) ON DELETE SET NULL,
  CONSTRAINT `assets_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `assets_room_id_foreign` FOREIGN KEY (`room_id`) REFERENCES `rooms` (`id`) ON DELETE SET NULL,
  CONSTRAINT `assets_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.assets: ~9 rows (approximately)
REPLACE INTO `assets` (`id`, `created_by`, `room_id`, `location_detail`, `name_asset`, `asset_category_id`, `asset_type`, `serial_number`, `description`, `purchase_date`, `condition`, `status`, `current_stock`, `minimum_stock`, `updated_by`, `created_at`, `updated_at`) VALUES
	(1, 1, 8, NULL, 'AC Central Daikin', 1, 'fixed_asset', 'AC-20260102-0001', NULL, NULL, 'Baik', 'maintenance', 1, 1, NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(2, 1, 8, NULL, 'Proyektor Epson EB-X500', 3, 'fixed_asset', 'PRJ-20260102-0001', NULL, NULL, 'Baik', 'maintenance', 1, 1, NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(3, 1, 5, NULL, 'Monitor LG 24 Inch', 2, 'fixed_asset', 'MON-20260102-0001', NULL, NULL, 'Baik', 'maintenance', 1, 1, NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(4, 1, 5, NULL, 'Meja Kerja Manajer', 5, 'fixed_asset', 'FUR-20260102-0001', NULL, NULL, 'Baik', 'maintenance', 1, 1, NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(5, 1, 4, NULL, 'Kopi Sachet ABC', 6, 'consumable', 'FNB-20260102-0001', NULL, NULL, 'Baik', 'available', 15, 5, NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(6, 1, 4, NULL, 'Bohlam LED Philips 12W', 9, 'consumable', 'ELK-20260102-0001', NULL, NULL, 'Baik', 'available', 8, 10, NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(7, 1, 4, NULL, 'Cairan Pembersih Lantai 1L', 7, 'consumable', 'CLN-20260102-0001', NULL, NULL, 'Baik', 'available', 4, 5, NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(8, 1, 4, NULL, 'Baterai AA Alkaline', 9, 'consumable', 'ELK-20260102-0002', NULL, NULL, 'Baik', 'available', 20, 24, NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(9, 1, 4, NULL, 'Spidol Papan Tulis Hitam', 8, 'consumable', 'ATK-20260102-0001', NULL, NULL, 'Baik', 'available', 10, 12, NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35');

-- Dumping structure for table db_mapro.assets_maintenances
CREATE TABLE IF NOT EXISTS `assets_maintenances` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `maintenance_type` enum('repair','routine_check','replacement') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `status` enum('scheduled','in_progress','completed','cancelled') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'scheduled',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assets_maintenances_asset_id_foreign` (`asset_id`),
  KEY `assets_maintenances_user_id_foreign` (`user_id`),
  CONSTRAINT `assets_maintenances_asset_id_foreign` FOREIGN KEY (`asset_id`) REFERENCES `assets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `assets_maintenances_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.assets_maintenances: ~4 rows (approximately)
REPLACE INTO `assets_maintenances` (`id`, `asset_id`, `user_id`, `start_date`, `end_date`, `maintenance_type`, `description`, `notes`, `status`, `created_at`, `updated_at`) VALUES
	(1, 1, 8, '2026-01-02 23:15:35', NULL, 'repair', 'Aset sedang dalam proses perbaikan terjadwal.', NULL, 'in_progress', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(2, 2, 8, '2026-01-02 23:15:35', NULL, 'repair', 'Aset sedang dalam proses perbaikan terjadwal.', NULL, 'in_progress', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(3, 3, 8, '2026-01-02 23:15:35', NULL, 'repair', 'Aset sedang dalam proses perbaikan terjadwal.', NULL, 'in_progress', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(4, 4, 8, '2026-01-02 23:15:35', NULL, 'repair', 'Aset sedang dalam proses perbaikan terjadwal.', NULL, 'in_progress', '2026-01-02 16:15:35', '2026-01-02 16:15:35');

-- Dumping structure for table db_mapro.asset_categories
CREATE TABLE IF NOT EXISTS `asset_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Kode singkatan kategori (AC, MON, PRJ, dll)',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `asset_categories_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.asset_categories: ~9 rows (approximately)
REPLACE INTO `asset_categories` (`id`, `name`, `code`, `created_at`, `updated_at`) VALUES
	(1, 'Air Conditioner', 'AC', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(2, 'Monitor', 'MON', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(3, 'Proyektor', 'PRJ', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(4, 'Laptop', 'LTP', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(5, 'Furniture', 'FUR', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(6, 'Konsumsi', 'FNB', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(7, 'Kebersihan', 'CLN', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(8, 'Alat Tulis Kantor', 'ATK', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(9, 'Elektronik Umum', 'ELK', '2026-01-02 16:15:35', '2026-01-02 16:15:35');

-- Dumping structure for table db_mapro.asset_movements
CREATE TABLE IF NOT EXISTS `asset_movements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL,
  `from_room_id` bigint unsigned DEFAULT NULL,
  `to_room_id` bigint unsigned DEFAULT NULL,
  `moved_by_user_id` bigint unsigned NOT NULL,
  `movement_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `task_id` bigint unsigned DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_movements_asset_id_foreign` (`asset_id`),
  KEY `asset_movements_from_room_id_foreign` (`from_room_id`),
  KEY `asset_movements_to_room_id_foreign` (`to_room_id`),
  KEY `asset_movements_moved_by_user_id_foreign` (`moved_by_user_id`),
  KEY `asset_movements_task_id_foreign` (`task_id`),
  CONSTRAINT `asset_movements_asset_id_foreign` FOREIGN KEY (`asset_id`) REFERENCES `assets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_movements_from_room_id_foreign` FOREIGN KEY (`from_room_id`) REFERENCES `rooms` (`id`) ON DELETE SET NULL,
  CONSTRAINT `asset_movements_moved_by_user_id_foreign` FOREIGN KEY (`moved_by_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_movements_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE SET NULL,
  CONSTRAINT `asset_movements_to_room_id_foreign` FOREIGN KEY (`to_room_id`) REFERENCES `rooms` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.asset_movements: ~0 rows (approximately)

-- Dumping structure for table db_mapro.asset_packing_list
CREATE TABLE IF NOT EXISTS `asset_packing_list` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `packing_list_id` bigint unsigned NOT NULL,
  `asset_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_packing_list_packing_list_id_foreign` (`packing_list_id`),
  KEY `asset_packing_list_asset_id_foreign` (`asset_id`),
  CONSTRAINT `asset_packing_list_asset_id_foreign` FOREIGN KEY (`asset_id`) REFERENCES `assets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_packing_list_packing_list_id_foreign` FOREIGN KEY (`packing_list_id`) REFERENCES `packing_lists` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.asset_packing_list: ~5 rows (approximately)
REPLACE INTO `asset_packing_list` (`id`, `packing_list_id`, `asset_id`, `created_at`, `updated_at`) VALUES
	(1, 1, 5, NULL, NULL),
	(2, 1, 6, NULL, NULL),
	(3, 1, 7, NULL, NULL),
	(4, 2, 8, NULL, NULL),
	(5, 2, 9, NULL, NULL);

-- Dumping structure for table db_mapro.buildings
CREATE TABLE IF NOT EXISTS `buildings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name_building` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `lat_building` double DEFAULT NULL,
  `long_building` double DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `buildings_created_by_foreign` (`created_by`),
  CONSTRAINT `buildings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.buildings: ~0 rows (approximately)
REPLACE INTO `buildings` (`id`, `name_building`, `address`, `lat_building`, `long_building`, `created_by`, `status`, `created_at`, `updated_at`) VALUES
	(1, 'Gedung Utama Manpro', 'Jl. Teknologi No. 1, Jakarta', NULL, NULL, 2, 'active', '2026-01-02 16:15:35', '2026-01-02 16:15:35');

-- Dumping structure for table db_mapro.cache
CREATE TABLE IF NOT EXISTS `cache` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.cache: ~0 rows (approximately)

-- Dumping structure for table db_mapro.cache_locks
CREATE TABLE IF NOT EXISTS `cache_locks` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.cache_locks: ~0 rows (approximately)

-- Dumping structure for table db_mapro.complaints
CREATE TABLE IF NOT EXISTS `complaints` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `reporter_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Nama pelapor, bisa tamu atau staff',
  `location_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Deskripsi lokasi, cth: Lobi dekat pintu barat',
  `status` enum('open','converted_to_task','closed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `room_id` bigint unsigned DEFAULT NULL,
  `asset_id` bigint unsigned DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `task_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `complaints_task_id_unique` (`task_id`),
  KEY `complaints_room_id_foreign` (`room_id`),
  KEY `complaints_asset_id_foreign` (`asset_id`),
  KEY `complaints_created_by_foreign` (`created_by`),
  CONSTRAINT `complaints_asset_id_foreign` FOREIGN KEY (`asset_id`) REFERENCES `assets` (`id`) ON DELETE SET NULL,
  CONSTRAINT `complaints_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `complaints_room_id_foreign` FOREIGN KEY (`room_id`) REFERENCES `rooms` (`id`) ON DELETE SET NULL,
  CONSTRAINT `complaints_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.complaints: ~0 rows (approximately)
REPLACE INTO `complaints` (`id`, `title`, `description`, `reporter_name`, `location_text`, `status`, `room_id`, `asset_id`, `created_by`, `task_id`, `created_at`, `updated_at`) VALUES
	(1, 'Toilet di Lobi Lt. 1 Mampet', 'Ada genangan air di toilet pria dekat lobi utama. Kemungkinan saluran pembuangan tersumbat. Mohon segera diperiksa.', 'Tamu Hotel (via Resepsionis)', 'Toilet Pria, Lobi Utama, Lantai 1', 'open', 1, NULL, 3, NULL, '2026-01-02 16:15:36', '2026-01-02 16:15:36');

-- Dumping structure for table db_mapro.failed_jobs
CREATE TABLE IF NOT EXISTS `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.failed_jobs: ~0 rows (approximately)

-- Dumping structure for table db_mapro.floors
CREATE TABLE IF NOT EXISTS `floors` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `building_id` bigint unsigned NOT NULL,
  `name_floor` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `floors_building_id_foreign` (`building_id`),
  KEY `floors_created_by_foreign` (`created_by`),
  CONSTRAINT `floors_building_id_foreign` FOREIGN KEY (`building_id`) REFERENCES `buildings` (`id`) ON DELETE CASCADE,
  CONSTRAINT `floors_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.floors: ~3 rows (approximately)
REPLACE INTO `floors` (`id`, `building_id`, `name_floor`, `created_by`, `status`, `created_at`, `updated_at`) VALUES
	(1, 1, 'Lantai 1', 2, 'active', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(2, 1, 'Lantai 2', 2, 'active', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(3, 1, 'Lantai 5 (Rooftop)', 2, 'active', '2026-01-02 16:15:35', '2026-01-02 16:15:35');

-- Dumping structure for table db_mapro.jobs
CREATE TABLE IF NOT EXISTS `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.jobs: ~0 rows (approximately)

-- Dumping structure for table db_mapro.job_batches
CREATE TABLE IF NOT EXISTS `job_batches` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.job_batches: ~0 rows (approximately)

-- Dumping structure for table db_mapro.migrations
CREATE TABLE IF NOT EXISTS `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.migrations: ~0 rows (approximately)
REPLACE INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(1, '0001_01_00_000000_create_roles_table', 1),
	(2, '0001_01_01_000000_create_users_table', 1),
	(3, '0001_01_01_000001_create_cache_table', 1),
	(4, '0001_01_01_000002_create_jobs_table', 1),
	(5, '2025_07_04_062257_create_buildings_table', 1),
	(6, '2025_07_04_062325_create_floors_table', 1),
	(7, '2025_07_04_062345_create_rooms_table', 1),
	(8, '2025_07_04_062416_create_task_types_table', 1),
	(9, '2025_07_04_062428_create_assets_table', 1),
	(10, '2025_07_04_062441_create_tasks_table', 1),
	(11, '2025_07_04_062552_create_assets_maintenances_table', 1),
	(12, '2025_07_04_062604_create_notifications_table', 1),
	(13, '2025_07_04_102119_create_personal_access_tokens_table', 1),
	(14, '2025_07_07_080617_add_created_by_to_assets_table', 1),
	(15, '2025_07_15_063522_add_rejection_notes_to_tasks_table', 1),
	(16, '2025_07_15_071553_add_priority_and_department_to_tasks_table', 1),
	(17, '2025_07_16_033118_remove_department_code_from_tasks_table', 1),
	(18, '2025_07_16_074707_add_asset_type_to_assets_table', 1),
	(19, '2025_07_17_040532_add_maintenance_link_to_tasks_table', 1),
	(20, '2025_09_02_160033_create_complaints_table', 1),
	(21, '2025_09_02_234551_modify_report_fields_in_tasks_table', 1),
	(22, '2025_09_04_094349_create_packing_lists_table', 1),
	(23, '2025_09_04_094508_create_asset_packing_list_table', 1),
	(24, '2025_10_01_090833_add_review_fields_to_tasks_table', 1),
	(25, '2025_10_02_070654_add_report_text_to_tasks_table', 1),
	(26, '2025_10_26_152106_add_signature_image_to_users_table', 1),
	(27, '2025_10_26_155008_add_signature_to_packing_lists_table', 1),
	(28, '2025_10_29_145238_create_asset_categories_table', 1),
	(29, '2025_10_29_145429_modify_kategori_in_assets_table', 1),
	(30, '2025_11_10_043316_add_revised_and_cancelled_to_tasks_status_enum_table', 1),
	(31, '2025_11_10_062929_add_location_detail_to_assets_table', 1),
	(32, '2025_11_10_062956_create_asset_movements_table', 1),
	(33, '2025_11_17_083857_create_task_report_histories_table', 1),
	(34, '2025_11_22_224511_add_automation_columns_to_task_types_table', 1),
	(35, '2025_11_22_224835_modify_task_type_conditions_to_enum', 1),
	(36, '2025_11_23_012624_add_code_to_asset_categories_table', 1),
	(37, '2025_12_09_211039_add_telegram_verification_token_to_users_table', 1);

-- Dumping structure for table db_mapro.notifications
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.notifications: ~0 rows (approximately)

-- Dumping structure for table db_mapro.packing_lists
CREATE TABLE IF NOT EXISTS `packing_lists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `document_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recipient_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `signature_pad` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `packing_lists_document_number_unique` (`document_number`),
  KEY `packing_lists_created_by_foreign` (`created_by`),
  CONSTRAINT `packing_lists_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.packing_lists: ~2 rows (approximately)
REPLACE INTO `packing_lists` (`id`, `document_number`, `recipient_name`, `created_by`, `notes`, `signature_pad`, `created_at`, `updated_at`) VALUES
	(1, 'PL-2025-001', 'Departemen Housekeeping', 11, 'Pengambilan stok bulanan.', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(2, 'PL-2025-002', 'Departemen Teknisi', 11, 'Kebutuhan perbaikan di lantai 5.', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35');

-- Dumping structure for table db_mapro.password_reset_tokens
CREATE TABLE IF NOT EXISTS `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.password_reset_tokens: ~0 rows (approximately)

-- Dumping structure for table db_mapro.personal_access_tokens
CREATE TABLE IF NOT EXISTS `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.personal_access_tokens: ~0 rows (approximately)

-- Dumping structure for table db_mapro.roles
CREATE TABLE IF NOT EXISTS `roles` (
  `role_id` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `role_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.roles: ~12 rows (approximately)
REPLACE INTO `roles` (`role_id`, `role_name`, `created_at`, `updated_at`) VALUES
	('HK01', 'Leader Housekeeping', NULL, NULL),
	('HK02', 'Staff Housekeeping', NULL, NULL),
	('MG00', 'Manager', NULL, NULL),
	('PK01', 'Leader Parking', NULL, NULL),
	('PK02', 'Staff Parking', NULL, NULL),
	('SA00', 'Superadmin', NULL, NULL),
	('SC01', 'Leader Security', NULL, NULL),
	('SC02', 'Staff Security', NULL, NULL),
	('TK01', 'Leader Teknisi', NULL, NULL),
	('TK02', 'Staff Teknisi', NULL, NULL),
	('WH01', 'Leader Warehouse', NULL, NULL),
	('WH02', 'Staff Warehouse', NULL, NULL);

-- Dumping structure for table db_mapro.rooms
CREATE TABLE IF NOT EXISTS `rooms` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `floor_id` bigint unsigned NOT NULL,
  `name_room` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rooms_floor_id_foreign` (`floor_id`),
  KEY `rooms_created_by_foreign` (`created_by`),
  CONSTRAINT `rooms_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `rooms_floor_id_foreign` FOREIGN KEY (`floor_id`) REFERENCES `floors` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.rooms: ~9 rows (approximately)
REPLACE INTO `rooms` (`id`, `floor_id`, `name_room`, `created_by`, `status`, `created_at`, `updated_at`) VALUES
	(1, 1, 'Lobi Utama', 2, 'active', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(2, 1, 'Toilet Pria Lobi', 2, 'active', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(3, 1, 'Toilet Wanita Lobi', 2, 'active', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(4, 1, 'Gudang Parkir B1', 2, 'active', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(5, 2, 'Kantor Manajer', 2, 'active', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(6, 2, 'Ruang Server', 2, 'active', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(7, 2, 'Pantry Lt. 2', 2, 'active', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(8, 3, 'Ruang Rapat Sakura', 2, 'active', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(9, 3, 'Taman Rooftop', 2, 'active', '2026-01-02 16:15:35', '2026-01-02 16:15:35');

-- Dumping structure for table db_mapro.sessions
CREATE TABLE IF NOT EXISTS `sessions` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.sessions: ~0 rows (approximately)

-- Dumping structure for table db_mapro.tasks
CREATE TABLE IF NOT EXISTS `tasks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `task_type_id` bigint unsigned DEFAULT NULL,
  `priority` enum('low','medium','high','critical') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'medium',
  `user_id` bigint unsigned DEFAULT NULL,
  `asset_id` bigint unsigned DEFAULT NULL,
  `assets_maintenance_id` bigint unsigned DEFAULT NULL,
  `room_id` bigint unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `report_text` text COLLATE utf8mb4_unicode_ci,
  `status` enum('unassigned','in_progress','pending_review','completed','rejected','revised','cancelled') COLLATE utf8mb4_unicode_ci DEFAULT 'unassigned',
  `rejection_notes` text COLLATE utf8mb4_unicode_ci,
  `reviewed_by` bigint unsigned DEFAULT NULL,
  `review_notes` text COLLATE utf8mb4_unicode_ci,
  `due_date` datetime DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `image_before` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_after` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tasks_task_type_id_foreign` (`task_type_id`),
  KEY `tasks_user_id_foreign` (`user_id`),
  KEY `tasks_asset_id_foreign` (`asset_id`),
  KEY `tasks_room_id_foreign` (`room_id`),
  KEY `tasks_created_by_foreign` (`created_by`),
  KEY `tasks_assets_maintenance_id_foreign` (`assets_maintenance_id`),
  KEY `tasks_reviewed_by_foreign` (`reviewed_by`),
  CONSTRAINT `tasks_asset_id_foreign` FOREIGN KEY (`asset_id`) REFERENCES `assets` (`id`) ON DELETE SET NULL,
  CONSTRAINT `tasks_assets_maintenance_id_foreign` FOREIGN KEY (`assets_maintenance_id`) REFERENCES `assets_maintenances` (`id`) ON DELETE SET NULL,
  CONSTRAINT `tasks_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `tasks_reviewed_by_foreign` FOREIGN KEY (`reviewed_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `tasks_room_id_foreign` FOREIGN KEY (`room_id`) REFERENCES `rooms` (`id`) ON DELETE SET NULL,
  CONSTRAINT `tasks_task_type_id_foreign` FOREIGN KEY (`task_type_id`) REFERENCES `task_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tasks_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.tasks: ~0 rows (approximately)

-- Dumping structure for table db_mapro.task_report_histories
CREATE TABLE IF NOT EXISTS `task_report_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `task_id` bigint unsigned NOT NULL,
  `submitted_by` bigint unsigned NOT NULL,
  `report_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image_before` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_after` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `submitted_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `review_action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `review_notes` text COLLATE utf8mb4_unicode_ci,
  `reviewed_by` bigint unsigned DEFAULT NULL,
  `reviewed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_report_histories_task_id_foreign` (`task_id`),
  KEY `task_report_histories_submitted_by_foreign` (`submitted_by`),
  KEY `task_report_histories_reviewed_by_foreign` (`reviewed_by`),
  CONSTRAINT `task_report_histories_reviewed_by_foreign` FOREIGN KEY (`reviewed_by`) REFERENCES `users` (`id`),
  CONSTRAINT `task_report_histories_submitted_by_foreign` FOREIGN KEY (`submitted_by`) REFERENCES `users` (`id`),
  CONSTRAINT `task_report_histories_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.task_report_histories: ~0 rows (approximately)

-- Dumping structure for table db_mapro.task_types
CREATE TABLE IF NOT EXISTS `task_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name_task` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `notification_template` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `departemen` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `asset_condition_on_create` enum('Baik','Rusak') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `asset_status_on_create` enum('available','in_use','maintenance','disposed') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `asset_condition_on_complete` enum('Baik','Rusak') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `asset_status_on_complete` enum('available','in_use','maintenance','disposed') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority_level` enum('low','medium','high','critical') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'medium',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.task_types: ~10 rows (approximately)
REPLACE INTO `task_types` (`id`, `name_task`, `description`, `notification_template`, `departemen`, `asset_condition_on_create`, `asset_status_on_create`, `asset_condition_on_complete`, `asset_status_on_complete`, `priority_level`, `created_at`, `updated_at`) VALUES
	(1, 'Pembersihan Rutin', NULL, NULL, 'HK', NULL, NULL, NULL, NULL, 'medium', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(2, 'Pengelolaan Sampah', NULL, NULL, 'HK', NULL, NULL, NULL, NULL, 'medium', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(3, 'Perbaikan Kelistrikan', NULL, NULL, 'TK', NULL, NULL, NULL, NULL, 'medium', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(4, 'Perbaikan Aset', NULL, NULL, 'TK', NULL, NULL, NULL, NULL, 'medium', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(5, 'Instalasi Baru', NULL, NULL, 'TK', NULL, NULL, NULL, NULL, 'medium', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(6, 'Patroli Keamanan', NULL, NULL, 'SC', NULL, NULL, NULL, NULL, 'medium', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(7, 'Pengawalan Tamu VIP', NULL, NULL, 'SC', NULL, NULL, NULL, NULL, 'medium', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(8, 'Pengaturan Lalu Lintas', NULL, NULL, 'PK', NULL, NULL, NULL, NULL, 'medium', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(9, 'Laporan Insiden', NULL, NULL, 'UMUM', NULL, NULL, NULL, NULL, 'medium', '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(10, 'Permintaan Bantuan', NULL, NULL, 'UMUM', NULL, NULL, NULL, NULL, 'medium', '2026-01-02 16:15:35', '2026-01-02 16:15:35');

-- Dumping structure for table db_mapro.users
CREATE TABLE IF NOT EXISTS `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_picture` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telegram_chat_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telegram_verification_token` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `signature_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `role_id` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  KEY `users_role_id_foreign` (`role_id`),
  CONSTRAINT `users_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`role_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_mapro.users: ~12 rows (approximately)
REPLACE INTO `users` (`id`, `name`, `email`, `email_verified_at`, `password`, `profile_picture`, `telegram_chat_id`, `telegram_verification_token`, `signature_image`, `role_id`, `status`, `remember_token`, `created_at`, `updated_at`) VALUES
	(1, 'Superadmin', 'superadmin@example.com', NULL, '$2y$12$AhMwrhgKImQpbqh9/Ok1N..Ev6RxLfbo0d31G1Lk4Fc4IMNSvAm4u', NULL, '648052160', NULL, NULL, 'SA00', 'active', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(2, 'Manager', 'manager@example.com', NULL, '$2y$12$yAVLIP/dWKxNmNXJr4T8Zul/CQCXAdSG42h4WoWGjbzNfbDWANFoO', NULL, '648052160', NULL, NULL, 'MG00', 'active', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(3, 'Leader Housekeeping', 'leader.hk@example.com', NULL, '$2y$12$w3Pmy/InLmiW3FINsNzMIeWhOkfKmcYJ5tTh2O6cDdp6rCXaZhqci', NULL, '648052160', NULL, NULL, 'HK01', 'active', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(4, 'Leader Teknisi', 'leader.tk@example.com', NULL, '$2y$12$XRS4p5OXlE1uLHYRhmfSKuATl6noq7KLToI7pCYzcemTzzWPQwUEG', NULL, '648052160', NULL, NULL, 'TK01', 'active', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(5, 'Leader Security', 'leader.sc@example.com', NULL, '$2y$12$oNQoYvPZEsUiEzCa9d9vnuytUJN1bZrYlKvL2bFjkCH5SE/ugzDtu', NULL, '648052160', NULL, NULL, 'SC01', 'active', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(6, 'Leader Parking', 'leader.pk@example.com', NULL, '$2y$12$bgLAdwO/i.kw0crN.VZ36.bIBeXQiUp1CV2dOMaShChKlHYNc/3fK', NULL, '648052160', NULL, NULL, 'PK01', 'active', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(7, 'Staff Housekeeping', 'staff.hk@example.com', NULL, '$2y$12$KzLUpIzsWVHexSjN6xF.FesBjoLMA3/KSEw3/d6VE3Ti8WlOyCnHq', NULL, '648052160', NULL, NULL, 'HK02', 'active', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(8, 'Staff Teknisi', 'staff.tk@example.com', NULL, '$2y$12$MrU0JObUmnwJYTseFd.2nO2KeN.2pzOz8D//x/kLJYuy4wQ8w373m', NULL, '648052160', NULL, NULL, 'TK02', 'active', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(9, 'Staff Security', 'staff.sc@example.com', NULL, '$2y$12$ZcCfkXBZ9Uai8pIEq50xFOVPI.0O9tQx6EWlk5s5Cv/kwsfBLjksS', NULL, '648052160', NULL, NULL, 'SC02', 'active', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(10, 'Staff Parking', 'staff.pk@example.com', NULL, '$2y$12$iaM7rr/f/OxaHhAoNEohXuOp1nxIiFakapYF7JDUvKZ8dXys1nA8C', NULL, '648052160', NULL, NULL, 'PK02', 'active', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(11, 'Leader Warehouse', 'leader.wh@example.com', NULL, '$2y$12$Se9riD2RW/FrC8P3ChUTgebYJC5iHe59iCVlooNjBg4xHfO5rU9/.', NULL, '648052160', NULL, NULL, 'WH01', 'active', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35'),
	(12, 'Staff Warehouse', 'staff.wh@example.com', NULL, '$2y$12$rswGbZrU9c4qy23y.VzrTO5AZOooDH/kKoNU3AUszpdHcd8w5ikQm', NULL, '648052160', NULL, NULL, 'WH02', 'active', NULL, '2026-01-02 16:15:35', '2026-01-02 16:15:35');

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
